/*
 * Decompiled with CFR 0.152.
 */
package control;

import org.lwjgl.opengl.GL11;
import view.Fonts;

public class Button {
    public int xLoc = 0;
    public int yLoc = 0;
    public String sButtonText = "";
    public float fScale = 1.0f;
    private int originalY;
    public static int xOffset = 0;
    public static int yOffset = 0;

    public Button(int x, int y, String sTextToSet, float inputScale) {
        this.xLoc = x;
        this.originalY = this.yLoc = y;
        this.sButtonText = sTextToSet;
        this.fScale = inputScale;
    }

    public void setText(String sTextToSet) {
        this.sButtonText = sTextToSet;
    }

    public void incY(int y) {
        this.yLoc += y;
    }

    public int getX() {
        return this.xLoc;
    }

    public int getY() {
        return this.yLoc;
    }

    public void resetY() {
        this.yLoc = this.originalY;
    }

    public void highlight() {
        int iButtonWidth = (int)(Fonts.getWidth(this.sButtonText, 1.0) + 10.0f);
        int iButtonHeight = (int)(Fonts.getHeight(this.sButtonText, 1.0) + 10.0f);
        GL11.glBegin(3);
        GL11.glVertex2d((float)(this.xLoc + xOffset) - (float)(iButtonWidth / 2) * this.fScale, (float)(this.yLoc + yOffset) - (float)(iButtonHeight / 2) * this.fScale);
        GL11.glVertex2d((float)(this.xLoc + xOffset) + (float)(iButtonWidth / 2) * this.fScale, (float)(this.yLoc + yOffset) - (float)(iButtonHeight / 2) * this.fScale);
        GL11.glVertex2d((float)(this.xLoc + xOffset) + (float)(iButtonWidth / 2) * this.fScale, (float)(this.yLoc + yOffset) + (float)(iButtonHeight / 2) * this.fScale);
        GL11.glVertex2d((float)(this.xLoc + xOffset) - (float)(iButtonWidth / 2) * this.fScale, (float)(this.yLoc + yOffset) + (float)(iButtonHeight / 2) * this.fScale);
        GL11.glVertex2d((float)(this.xLoc + xOffset) - (float)(iButtonWidth / 2) * this.fScale, (float)(this.yLoc + yOffset) - (float)(iButtonHeight / 2) * this.fScale);
        GL11.glEnd();
    }

    public void fill() {
        int iButtonWidth = (int)(Fonts.getWidth(this.sButtonText, 1.0) + 10.0f);
        int iButtonHeight = (int)(Fonts.getHeight(this.sButtonText, 1.0) + 10.0f);
        GL11.glColor3f(1.0f, 1.0f, 1.0f);
        GL11.glBegin(9);
        GL11.glVertex2d((float)(this.xLoc + xOffset) - (float)(iButtonWidth / 2) * this.fScale, (float)(this.yLoc + yOffset) - (float)(iButtonHeight / 2) * this.fScale);
        GL11.glVertex2d((float)(this.xLoc + xOffset) + (float)(iButtonWidth / 2) * this.fScale, (float)(this.yLoc + yOffset) - (float)(iButtonHeight / 2) * this.fScale);
        GL11.glVertex2d((float)(this.xLoc + xOffset) + (float)(iButtonWidth / 2) * this.fScale, (float)(this.yLoc + yOffset) + (float)(iButtonHeight / 2) * this.fScale);
        GL11.glVertex2d((float)(this.xLoc + xOffset) - (float)(iButtonWidth / 2) * this.fScale, (float)(this.yLoc + yOffset) + (float)(iButtonHeight / 2) * this.fScale);
        GL11.glVertex2d((float)(this.xLoc + xOffset) - (float)(iButtonWidth / 2) * this.fScale, (float)(this.yLoc + yOffset) - (float)(iButtonHeight / 2) * this.fScale);
        GL11.glEnd();
    }

    public void draw() {
        Fonts.drawText(this.xLoc + xOffset, this.yLoc + yOffset, this.fScale, this.sButtonText, true);
    }

    public boolean checkCollision(int inputX, int inputY) {
        boolean bRet = false;
        int iHalfButtonWidth = (int)(Fonts.getWidth(this.sButtonText, 1.0) / 2.0f);
        int iHalfButtonHeight = (int)(Fonts.getHeight(this.sButtonText, 1.0) / 2.0f);
        if (this.xLoc + xOffset - iHalfButtonWidth < inputX && this.xLoc + xOffset + iHalfButtonWidth > inputX && this.yLoc + yOffset + iHalfButtonHeight > inputY && this.yLoc + yOffset - iHalfButtonHeight < inputY) {
            bRet = true;
        }
        return bRet;
    }

    public float getButtonWidth() {
        return Fonts.getWidth(this.sButtonText, this.fScale);
    }

    public float getButtonHeight() {
        return Fonts.getHeight(this.sButtonText, this.fScale);
    }

    public float getXCenter() {
        return this.xLoc + xOffset;
    }

    public float getYCenter() {
        return this.yLoc + yOffset;
    }
}

